'use strict';

/**
 * PazarRadar - Landing Page Otomatik Lisans Aktivasyonu
 *
 * Odeme sonrasi landing page'de body'ye eklenen data-pr-license-key
 * attribute'unu izler ve eklenti yukluyse otomatik aktive eder.
 */
(function() {
  var activated = false;
  var observer = null;
  var LICENSE_PATTERN = /^PR-[A-HJ-NP-Z2-9]{4}-[A-HJ-NP-Z2-9]{4}-[A-HJ-NP-Z2-9]{4}-[A-HJ-NP-Z2-9]{4}$/;

  function updateStatus(type, message) {
    var el = document.getElementById('activationStatus');
    if (!el) return;
    el.className = 'success-banner__activation success-banner__activation--' + type;
    el.textContent = message;
  }

  function tryActivate(key) {
    if (activated) return;
    if (!key || !LICENSE_PATTERN.test(key)) return;
    activated = true;

    // Eklentinin background'una mesaj gonder
    chrome.runtime.sendMessage(
      { type: 'activate_license', payload: { key: key } },
      function(response) {
        if (chrome.runtime.lastError) {
          // Eklenti yuklenmemis veya erisim yok
          updateStatus('err', 'Eklenti bulunamadi. Anahtari kopyalayip eklentiden girebilirsiniz.');
          return;
        }
        if (response && response.success) {
          updateStatus('ok', 'Eklentide otomatik aktive edildi!');
        } else {
          var errMsg = (response && response.error) || 'Aktivasyon basarisiz';
          updateStatus('err', errMsg + ' - Anahtari kopyalayip eklentiden girebilirsiniz.');
        }
      }
    );
  }

  // Sayfa yuklendiginde attribute zaten varsa hemen dene
  var existingKey = document.body.getAttribute('data-pr-license-key');
  if (existingKey) {
    tryActivate(existingKey);
  }

  // MutationObserver ile attribute degisikligini izle
  observer = new MutationObserver(function(mutations) {
    for (var i = 0; i < mutations.length; i++) {
      if (mutations[i].attributeName === 'data-pr-license-key') {
        var key = document.body.getAttribute('data-pr-license-key');
        if (key) {
          tryActivate(key);
          cleanup();
        }
        break;
      }
    }
  });

  observer.observe(document.body, { attributes: true, attributeFilter: ['data-pr-license-key'] });

  function cleanup() {
    if (observer) {
      observer.disconnect();
      observer = null;
    }
  }

  // 30sn sonra observer'i kapat (kaynak tasarrufu)
  setTimeout(cleanup, 30000);
})();
